/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-2-Clause) */
/* Copyright Authors of Cilium */

#pragma once

#include <linux/types.h>
#include <linux/bpf.h>

#include "../compiler.h"
#include "../errno.h"

#define __ctx_skb		1
#define __ctx_xdp		2

static __always_inline bool ctx_no_room(const void *needed, const void *limit)
{
	return unlikely(needed > limit);
}

static __always_inline bool ctx_is_skb(void)
{
	return __ctx_is == __ctx_skb;
}

static __always_inline bool ctx_is_xdp(void)
{
	return __ctx_is == __ctx_xdp;
}
